% SETILS - define ILS block parameters
%
% This routine can be used to create a set of standard block-
% parameters for the ILS radio-navigation model, taking into 
% account all relevant fixed geometrical data and signal
% sensitivity values, but leaving the initial position of the 
% aircraft relatively to the runway to be set separately. 
%
% The defined ILS parameters are: the runway altitude, reference
% glideslope angle, reference runway heading, distances from 
% runway threshold to the localizer and glideslope antennas,
% and the sensitivity of the glideslope and localizer receivers.

clc
disp(' ');
disp('Define ILS block parameters');
disp('===========================');
HRW   = input('Runway altitude above sea-level [m] (default 0 m): ');
if isempty(HRW)
   HRW = 0;
end
gamgs = input('Reference flightpath angle on glideslope [deg] (default -3 deg): ');
if isempty(gamgs)
   gamgs = -3;
end
psiRW = input('Reference heading of runway [deg] (default 0 deg): ');
if isempty(psiRW)
   psiRW = 0;
end
xloc  = input('X-distance from runway threshold to LOC antenna [m] (dflt 3000 m): ');
if isempty(xloc)
   xloc = 3000;
end
xgs   = input('X-distance from runway threshold to GS antenna [m] (dflt 300 m): ');
if isempty(xgs)
   xgs = 300;
end
ygs   = input('Y-distance from runway centerline to GS antenna [m] (dflt -100 m): ');
if isempty(ygs)
   ygs = -100;
end

disp(' ');
disp('<< Press key to save the results >>');
pause

% Save the ILS parameters to file. The default folder for this action 
% is the DATA subdirectory, which is stored in the variable defdir. The 
% current directory is stored in the variable currentdir, which is used
% if the default directory can't be found.
% ---------------------------------------------------------------------
defdir = datadir;
currentdir = chdir;

% Go to default directory if that directory exists (if not, start
% save-routine from the current directory).
% ---------------------------------------------------------------
try
  chdir(defdir);
catch
  chdir(currentdir);
end

% Obtain path (use default filename ILS.DAT)
% ------------------------------------------
[filename,dirname] = uiputfile('ils.dat','Save ILS parameters');

% Save results to the specified file
% ----------------------------------
save([dirname,filename],'HRW','gamgs','psiRW','xloc','xgs','ygs');

% Return to previous directory and quit
% -------------------------------------
chdir(currentdir);
disp(' ');
disp('Ready.');
disp(' ');


%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004.
%-----------------------------------------------------------------------